clear
set more off
capture log close
version 14

global j "D:\Home\aejack\Research\NewTechnologies\TillReceiptScanning\junk2"


* Participation in Spending Study
************************************

* DATA SETUP
*****************

use $j/cr-7, clear

svyset 	i_psu, strata(i_strata)

* keep only first observation from each respondent
bysort pidp (starttime): keep if _n==1
count

* drop those found ineligible for the scanning study
drop if eligible==0
tab eligible

* drop IP9 non-respondents
tab ip9
tab ip9, nolab
keep if ip9==1


* derive income bands (percentiles)
pctile inc = i_fimngrs_dv, nquantiles(10)
xtile incpctiles = i_fimngrs_dv, cutpoints(inc)
recode incpctiles .=11
* quartiles
pctile inc2 = i_fimngrs_dv, nquantiles(4)
xtile incquartiles = i_fimngrs_dv, cutpoints(inc2)
recode incquartiles .=11


* derive hh food spending bands (percentiles)
pctile exp = hhfood, nquantiles(10)
xtile exppctiles = hhfood, cutpoints(exp)
recode exppctiles .=11
* quartiles
pctile exp2 = hhfood, nquantiles(4)
xtile expquartiles = hhfood, cutpoints(exp2)
recode expquartiles .=11

* derive hh fuel expenditure bands (percentiles)
mvdecode utilities, mv(-1)
pctile fuel = utilities, nquantiles(10)
xtile fuelpctiles = utilities, cutpoints(fuel)
recode fuelpctiles .=11
* quartiles
pctile fuel2 = utilities, nquantiles(4)
xtile fuelquartiles = utilities, cutpoints(fuel2)
recode fuelquartiles .=11
tab1 fuelpctiles fuelquartiles

* mode of IP9 interview:
tab i_indmode

* number of IP9 respondents who reported not having a mobile device who used the app
tab smtab_dv everapp_dv, row 
tab smtab_dv everapp_dv, row miss



* analysis samples:
*********************

* full sample
**************
* includes 63 Rs who did not answer Q about mobile devices
* did not complete self-completion module or item non-response on the questions
* drop for all analyses for this RQ

tab smtabmiss

gen hasdevice = 1 if smtabmiss==1 
* recode participants who had reported not using internet or not using mobile device to connect to internet
* as having a device
replace hasdevice = 1 if everapp_dv==1 & (smtabmiss==0 | smtabmiss==-1) 
replace hasdevice = 0 if (smtabmiss==0 | smtabmiss==-1) & hasdevice==.
lab def hasdevice 0 "no" 1 "yes"
lab val hasdevice hasdevice
lab var hasdevice "has mobile device?"
tab smtabmiss hasdevice, miss

gen nonmiss = hasdevice<.
lab var hasdevice "mobile device status known"
tab hasdevice nonmiss, miss

* condition all analyses on "hasdevice<." or "hasdevice==1"
* i.e. drop cases where device status is unknown from analyses


* ANALYSIS
***********

* RQ6: Non-coverage and non-response bias
*********************************************

* item non-response in variables used
foreach w of varlist i_sex age_dv qual incquartiles expquartiles  fuelquartiles bills i_finnow ///
	i_finbud* i_bankbal i_balhow* i_taxsa i_accountnt i_finhelp i_loyalty96 {
	tab `w', miss
	}


* tests for differences between participants and non-participants
tab everapp_dv
tab everapp_dv, nolab
tab hasdevice
tab hasdevice, nolab

capture matrix drop All
matrix All = J(1,16,.)

// i_finsite* 
foreach w of varlist i_sex age_dv qual incquartiles expquartiles  fuelquartiles bills i_finnow ///
	i_finbud* i_bankbal i_balhow* i_taxsa i_loyalty96  {

* frequency distributions for all sub-samples

* full sample
tab `w' if `w'>=0, matcell(FullN) 
matrix rownames FullN = `w'

* full sample conditional on known device ownership status
tab `w' if `w'>=0 & hasdevice<., matcell(NonmissN) 
matrix rownames NonmissN = `w'

* device users conditional on known device ownership status
tab `w' if `w'>=0 & hasdevice==1, matcell(UsersN) 
matrix rownames UsersN = `w'

* participants conditional on device ownership
tab `w' if `w'>=0 & hasdevice==1 & everapp_dv==1 , matcell(CondpartN)
matrix rownames CondpartN = `w'



* get count of number of categories for each `w' variable
* use to define number of rows in matrices created below
local rows = rowsof(FullN)

* calcluate col total
matrix U = J(`rows',1,1)
matrix list U

foreach group in Full Nonmiss Users Condpart {
	matrix Tot`group' = U'*`group'N
	local Tot`group' = Tot`group'[1,1]
	}


* calculate col %
matrix FullPer = FullN/`TotFull'*100
matrix list FullPer

matrix NonmissPer = NonmissN/`TotNonmiss'*100
matrix list NonmissPer

matrix UsersPer = UsersN/`TotUsers'*100
matrix list UsersPer

matrix CondpartPer = CondpartN/`TotCondpart'*100
matrix list CondpartPer
	
	

* calculate differences in col %
matrix Diff1 = NonmissPer - FullPer
matrix Diff2 = UsersPer - NonmissPer
matrix Diff3 = CondpartPer - UsersPer
matrix Diff4 = CondpartPer - NonmissPer


* test for significance of differences
matrix Pvalue1 = J(`rows',1,.)
svy: tab nonmiss `w' if `w'>=0, percent row
matrix Pvalue1[`rows',1]=e(p_Pear)

matrix Pvalue2 = J(`rows',1,.)
svy: tab hasdevice `w' if `w'>=0 & hasdevice<., percent row
matrix Pvalue2[`rows',1]=e(p_Pear)

matrix Pvalue3 = J(`rows',1,.)
svy: tab everapp_dv `w' if `w'>=0 & hasdevice==1, percent row
matrix Pvalue3[`rows',1]=e(p_Pear)

matrix Pvalue4 = J(`rows',1,.)
svy: tab everapp_dv `w' if `w'>=0 & hasdevice<., percent row
matrix Pvalue4[`rows',1]=e(p_Pear)


* combine matrices

matrix A`w' = 	FullN,FullPer,NonmissN,NonmissPer,Diff1,Pvalue1,UsersN,UsersPer,Diff2,Pvalue2,CondpartN,CondpartPer,Diff3,Pvalue3,Diff4,Pvalue4			
matrix colnames A`w' = FullN FullPer ///
				NonmissN NonmissPer Diff1 Pvalue1 ///
				UsersN UsersPer Diff2 Pvalue2 ///
				CondpartN CondpartPer Diff3 Pvalue3 Diff4 Pvalue4
matrix list A`w'

matrix All = All\A`w'
matrix colnames All = FullN FullPer ///
				NonmissN NonmissPer Diff1 Pvalue1 ///
				UsersN UsersPer Diff2 Pvalue2 ///
				CondpartN CondpartPer Diff3 Pvalue3 Diff4 Pvalue4
}

matrix list All



exit




